/** @file   particleblood.h
 * @brief   Declaration of ParticleBlood - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_PARTICLEBLOOD_H
#define H_ENG2D_PARTICLEBLOOD_H

#include "eng2d_dll.h"
#include "particlesystem.h"

namespace eng2d {


/** @class  ParticleBlood
 * @brief   Creates a blood effect.
 * @author  Tomi Lamminsaari
 *
 * This creates a ParticleSystem with certain number of particles.
 */
class DLLIMPORT ParticleBlood : public ParticleSystem
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================
  
  /** The average lifetime. */
  static int averageLifetime;

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     rP                Starting position of the particles.
   * @param     rD                The main direction the particles move. The
   *                              magnitude of this vector affects the velocity
   *                              of the particles.
   * @param     num               Number of particles.
   * @param     rC                Color of the particles.
   */
	ParticleBlood( const Vec2D& rP, const Vec2D& rD, int num, const Color& rC );

	/** Destructor
   */
	virtual ~ParticleBlood();

private:
  ParticleBlood( const ParticleBlood& rO );
  ParticleBlood& operator = ( const ParticleBlood& rO );
public:
  
  /** Overrides the default implement so we can use transparency.
   * @param     aTarget           Target bitmap.
   * @param     aOffset           Offset to translate from world-coordinates
   *                              to screen coordinates.
   */
  virtual void redraw( BITMAP* aTarget, const Vec2D& aOffset );
};

};  // end of namespace


#endif
